(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     74032,       1570]
NotebookOptionsPosition[     71257,       1476]
NotebookOutlinePosition[     71866,       1498]
CellTagsIndexPosition[     71823,       1495]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "\n",
 StyleBox["Z , internal spherical diffusion",
  FontFamily->"Arial",
  FontSize->20]
}], "Title",
 CellChangeTimes->{
  3.475865912414785*^9, {3.475865943298551*^9, 3.475865955268236*^9}, {
   3.4758660429022484`*^9, 3.475866079428337*^9}, {3.475866316276884*^9, 
   3.4758663189490376`*^9}, {3.4899180970833187`*^9, 
   3.4899181046177497`*^9}, {3.521476712575059*^9, 3.5214767156602354`*^9}, {
   3.5214771897083497`*^9, 3.521477193004538*^9}, {3.5218873523293095`*^9, 
   3.5218873564375443`*^9}, {3.570533035842108*^9, 3.5705330403803673`*^9}, 
   3.5705382339774246`*^9, {3.570553977298891*^9, 3.570553984193285*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Off", "[", 
    RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4899223475414314`*^9, 3.489922372043833*^9}, {
  3.489922422316708*^9, 3.4899225446377044`*^9}, {3.4899231471981688`*^9, 
  3.489923148842263*^9}, {3.5218889390790663`*^9, 3.521888942727275*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Cdl\"\>", ",", "\<\"Co\"\>", ",", "\<\"Dox\"\>", 
   ",", "\<\"F\"\>", ",", "\<\"lom\"\>", ",", "\<\"lZM\"\>", ",", "\<\"R\"\>",
    ",", "\<\"r0\"\>", ",", "\<\"Rct\"\>", ",", "\<\"res\"\>", 
   ",", "\<\"Rs\"\>", ",", "\<\"T\"\>", ",", "\<\"Z\"\>", ",", "\<\"Z1\"\>", 
   ",", "\<\"Z2\"\>", ",", "\<\"Zf\"\>", ",", "\<\"ZM\"\>", ",", "\<\"Zw\"\>",
    ",", "\<\"\[Sigma]\"\>", ",", "\<\"\[CurlyPhi]\"\>", 
   ",", "\<\"\[Omega]\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.4899224480931826`*^9, 3.4899224680093217`*^9}, {
   3.4899225132789106`*^9, 3.489922572867319*^9}, 3.4899227588979597`*^9, 
   3.4899229525470357`*^9, {3.489923150031331*^9, 3.4899231591338515`*^9}, 
   3.4899232103387804`*^9, {3.4899232425756245`*^9, 3.489923428631266*^9}, 
   3.4899235748226275`*^9, 3.489924077427375*^9, 3.4899241356177034`*^9, 
   3.4899242249058104`*^9, {3.4899242571656556`*^9, 3.4899242784588737`*^9}, 
   3.489924406675207*^9, 3.489924454993971*^9, 3.489924529655241*^9, 
   3.4899245705055776`*^9, 3.489924620959463*^9, 3.5214767197844715`*^9, 
   3.521482241373288*^9, 3.5218881575273647`*^9, 3.5218884336581583`*^9, 
   3.521888592062218*^9, 3.521888625525132*^9, 3.5218889436613283`*^9, 
   3.521889196707802*^9, 3.521889326388219*^9, 3.5218896353968935`*^9, 
   3.5218899920282917`*^9, 3.5218901311722507`*^9, 3.52189052996806*^9, 
   3.5218906339220057`*^9, 3.5218909004972534`*^9, 3.5218923925335927`*^9, 
   3.5218924780914865`*^9, 3.52189263061121*^9, 3.521893227968377*^9, 
   3.521902173010004*^9, 3.521904360150101*^9, 3.521905128757063*^9, 
   3.52191141682472*^9, 3.570533733413007*^9, 3.570533910188118*^9, 
   3.57053934340388*^9, 3.570555127082655*^9, 3.5705553201646986`*^9, 
   3.5705555073474045`*^9, 3.5705555648816957`*^9, 3.5705571982221174`*^9, 
   3.570557235474248*^9, 3.5705572710812845`*^9, 3.570557954506374*^9, {
   3.5705580936843348`*^9, 3.57055813259256*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Sigma]", "=", 
  RowBox[{"R", "*", 
   RowBox[{"T", "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["F", "2"], "*", "Co", "*", 
      RowBox[{"Sqrt", "[", "Dox", "]"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4756024908337126`*^9, 3.4756025132197514`*^9}, 
   3.475602710568898*^9, 3.4756028164586835`*^9, {3.475604014994418*^9, 
   3.4756040188336377`*^9}, {3.4756041023064117`*^9, 3.475604103042454*^9}, 
   3.4756042857619047`*^9, {3.4758607424280787`*^9, 3.4758607461322904`*^9}, {
   3.4758653363428354`*^9, 3.4758654700724845`*^9}, {3.4758656911581297`*^9, 
   3.475865692438203*^9}, {3.4758657258471136`*^9, 3.475865727415203*^9}, {
   3.4758660945682034`*^9, 3.4758662093987713`*^9}, 3.4758662524252324`*^9, 
   3.4758663224082355`*^9, {3.4758664993513556`*^9, 3.475866500230406*^9}, {
   3.4758665335913143`*^9, 3.47586653421535*^9}, {3.4759198606664486`*^9, 
   3.4759198680258694`*^9}, {3.4899183954853864`*^9, 
   3.4899186045743456`*^9}, {3.4899186811347246`*^9, 3.4899186819507713`*^9}, 
   3.48991949963054*^9, 3.489920529485444*^9, 3.4899208179169416`*^9, 
   3.4899211413724422`*^9, {3.4899227490373955`*^9, 3.4899227507164917`*^9}, {
   3.4899234830853806`*^9, 3.4899234915648656`*^9}, {3.5214767369024506`*^9, 
   3.5214767910695486`*^9}, {3.5218874144458623`*^9, 3.521887421799283*^9}, {
   3.521888146758748*^9, 3.5218881523740697`*^9}, {3.5705330475077753`*^9, 
   3.5705331045800395`*^9}, 3.5705337217633405`*^9, {3.570533914131343*^9, 
   3.5705339276821184`*^9}, {3.5705383096987553`*^9, 3.570538399684902*^9}, {
   3.570538455217078*^9, 3.5705385242120247`*^9}, {3.5705385781811113`*^9, 
   3.5705386130431056`*^9}, {3.5705386973959303`*^9, 
   3.5705388328526783`*^9}, {3.5705388686457253`*^9, 
   3.5705388937151594`*^9}, {3.5705539935738215`*^9, 3.5705540484529605`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"R", " ", "T"}], 
  RowBox[{"Co", " ", 
   SqrtBox["Dox"], " ", 
   SuperscriptBox["F", "2"]}]]], "Output",
 CellChangeTimes->{
  3.5705388964243145`*^9, 3.5705393435168867`*^9, 3.5705540511101127`*^9, 
   3.570555127196661*^9, 3.5705553203117065`*^9, 3.570555514380807*^9, 
   3.5705555650777063`*^9, 3.5705571983761263`*^9, 3.570557235591254*^9, 
   3.5705572711862907`*^9, 3.5705579546343813`*^9, {3.5705580938113422`*^9, 
   3.5705581327385683`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zw", "=", 
  RowBox[{"\[Sigma]", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"\[ImaginaryI]", "*", "\[Omega]"}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{"Coth", "[", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"\[ImaginaryI]", "*", 
           RowBox[{"\[Omega]", "/", "Dox"}]}], "]"}], "*", "r0"}], "]"}], 
       ")"}]}], "-", 
     RowBox[{
      RowBox[{"Sqrt", "[", "Dox", "]"}], "/", "r0"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5705392072310915`*^9, 3.5705392132664366`*^9}, {
  3.5705540591705737`*^9, 3.5705543167563066`*^9}, {3.570555519555103*^9, 
  3.570555522548274*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"R", " ", "T"}], 
  RowBox[{"Co", " ", 
   SqrtBox["Dox"], " ", 
   SuperscriptBox["F", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox["Dox"], "r0"]}], "+", 
     RowBox[{
      SqrtBox[
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
      RowBox[{"Coth", "[", 
       RowBox[{"r0", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], "]"}]}]}], 
    ")"}]}]]], "Output",
 CellChangeTimes->{
  3.5705392149565334`*^9, 3.570539343543888*^9, 3.5705542143624496`*^9, {
   3.5705542553907967`*^9, 3.570554278495118*^9}, 3.5705543199654903`*^9, 
   3.570555127222663*^9, 3.57055532036771*^9, 3.5705555235353303`*^9, 
   3.57055556513371*^9, 3.5705571984211283`*^9, 3.570557235619256*^9, 
   3.5705572712172923`*^9, 3.570557954669383*^9, {3.570558093856344*^9, 
   3.570558132799572*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zf", "=", 
  RowBox[{"Rct", "+", "Zw"}]}]], "Input",
 CellChangeTimes->{{3.5705543548144836`*^9, 3.5705543616518745`*^9}}],

Cell[BoxData[
 RowBox[{"Rct", "+", 
  FractionBox[
   RowBox[{"R", " ", "T"}], 
   RowBox[{"Co", " ", 
    SqrtBox["Dox"], " ", 
    SuperscriptBox["F", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SqrtBox["Dox"], "r0"]}], "+", 
      RowBox[{
       SqrtBox[
        RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
       RowBox[{"Coth", "[", 
        RowBox[{"r0", " ", 
         SqrtBox[
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], "]"}]}]}], 
     ")"}]}]]}]], "Output",
 CellChangeTimes->{
  3.570554363002952*^9, 3.5705551272456636`*^9, 3.5705553204257135`*^9, 
   3.57055552685052*^9, 3.5705555651917133`*^9, 3.5705571984721317`*^9, 
   3.5705572356532583`*^9, 3.570557271260295*^9, 3.570557954715386*^9, {
   3.5705580938923464`*^9, 3.570558132861575*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z", "=", 
  RowBox[{"Rs", "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", "Zf"}], "+", 
      RowBox[{"\[ImaginaryI]", "*", "\[Omega]", "*", "Cdl"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.570554375573671*^9, 3.5705544213962917`*^9}}],

Cell[BoxData[
 RowBox[{"Rs", "+", 
  FractionBox["1", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
    FractionBox["1", 
     RowBox[{"Rct", "+", 
      FractionBox[
       RowBox[{"R", " ", "T"}], 
       RowBox[{"Co", " ", 
        SqrtBox["Dox"], " ", 
        SuperscriptBox["F", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox[
            SqrtBox["Dox"], "r0"]}], "+", 
          RowBox[{
           SqrtBox[
            RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
           RowBox[{"Coth", "[", 
            RowBox[{"r0", " ", 
             SqrtBox[
              FractionBox[
               RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
            "]"}]}]}], ")"}]}]]}]]}]]}]], "Output",
 CellChangeTimes->{
  3.5705544238674335`*^9, 3.570555127297667*^9, 3.5705553204827166`*^9, 
   3.5705555291666527`*^9, 3.570555565250716*^9, 3.570557198519134*^9, 
   3.5705572356792593`*^9, 3.570557271289296*^9, 3.5705579547543883`*^9, {
   3.5705580939383492`*^9, 3.5705581329195786`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z1", "=", 
  RowBox[{"Re", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.5705544366851664`*^9, 3.570554446386721*^9}}],

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox[
        RowBox[{"R", " ", "T"}], 
        RowBox[{"Co", " ", 
         SqrtBox["Dox"], " ", 
         SuperscriptBox["F", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             SqrtBox["Dox"], "r0"]}], "+", 
           RowBox[{
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
            RowBox[{"Coth", "[", 
             RowBox[{"r0", " ", 
              SqrtBox[
               FractionBox[
                RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
             "]"}]}]}], ")"}]}]]}]]}]]}], "]"}]], "Output",
 CellChangeTimes->{
  3.570554447671795*^9, 3.5705551273266687`*^9, 3.57055532054072*^9, 
   3.5705555653087196`*^9, 3.5705568274239087`*^9, 3.5705571985761375`*^9, 
   3.570557235721262*^9, 3.570557271341299*^9, 3.5705579548053913`*^9, {
   3.5705580939923525`*^9, 3.570558132978582*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z2", "=", 
  RowBox[{"Im", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.570554449777915*^9, 3.5705544568673205`*^9}}],

Cell[BoxData[
 RowBox[{"Im", "[", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox[
        RowBox[{"R", " ", "T"}], 
        RowBox[{"Co", " ", 
         SqrtBox["Dox"], " ", 
         SuperscriptBox["F", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             SqrtBox["Dox"], "r0"]}], "+", 
           RowBox[{
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
            RowBox[{"Coth", "[", 
             RowBox[{"r0", " ", 
              SqrtBox[
               FractionBox[
                RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
             "]"}]}]}], ")"}]}]]}]]}]]}], "]"}]], "Output",
 CellChangeTimes->{
  3.5705544587714295`*^9, 3.570555127376672*^9, 3.5705553206007233`*^9, 
   3.570555565362723*^9, 3.5705568312251263`*^9, 3.5705571986381407`*^9, 
   3.570557235754264*^9, 3.5705572713763013`*^9, 3.5705579548483934`*^9, {
   3.5705580940273542`*^9, 3.5705581330375853`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ZM", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Z1", "^", "2"}], "+", 
    RowBox[{"Z2", "^", "2"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"lZM", "=", 
  RowBox[{"Log10", "[", "ZM", "]"}]}]}], "Input",
 CellChangeTimes->{{3.5705544727082267`*^9, 3.5705544926593676`*^9}, {
  3.570554806084295*^9, 3.5705548115736084`*^9}}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Im", "[", 
     RowBox[{"Rs", "+", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
        FractionBox["1", 
         RowBox[{"Rct", "+", 
          FractionBox[
           RowBox[{"R", " ", "T"}], 
           RowBox[{"Co", " ", 
            SqrtBox["Dox"], " ", 
            SuperscriptBox["F", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                SqrtBox["Dox"], "r0"]}], "+", 
              RowBox[{
               SqrtBox[
                RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
               RowBox[{"Coth", "[", 
                RowBox[{"r0", " ", 
                 SqrtBox[
                  FractionBox[
                   RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
                "]"}]}]}], ")"}]}]]}]]}]]}], "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Re", "[", 
     RowBox[{"Rs", "+", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
        FractionBox["1", 
         RowBox[{"Rct", "+", 
          FractionBox[
           RowBox[{"R", " ", "T"}], 
           RowBox[{"Co", " ", 
            SqrtBox["Dox"], " ", 
            SuperscriptBox["F", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                SqrtBox["Dox"], "r0"]}], "+", 
              RowBox[{
               SqrtBox[
                RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
               RowBox[{"Coth", "[", 
                RowBox[{"r0", " ", 
                 SqrtBox[
                  FractionBox[
                   RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
                "]"}]}]}], ")"}]}]]}]]}]]}], "]"}], "2"]}]]], "Output",
 CellChangeTimes->{
  3.570554493429412*^9, 3.5705548131526985`*^9, 3.5705551274066734`*^9, 
   3.570555320663727*^9, 3.5705555654227266`*^9, 3.570557198701144*^9, 
   3.5705572357882657`*^9, 3.570557271410303*^9, 3.5705579548883963`*^9, {
   3.5705580940633564`*^9, 3.5705581330955887`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Im", "[", 
       RowBox[{"Rs", "+", 
        FractionBox["1", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
          FractionBox["1", 
           RowBox[{"Rct", "+", 
            FractionBox[
             RowBox[{"R", " ", "T"}], 
             RowBox[{"Co", " ", 
              SqrtBox["Dox"], " ", 
              SuperscriptBox["F", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 FractionBox[
                  SqrtBox["Dox"], "r0"]}], "+", 
                RowBox[{
                 SqrtBox[
                  RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
                 RowBox[{"Coth", "[", 
                  RowBox[{"r0", " ", 
                   SqrtBox[
                    FractionBox[
                    RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
                  "]"}]}]}], ")"}]}]]}]]}]]}], "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"Re", "[", 
       RowBox[{"Rs", "+", 
        FractionBox["1", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
          FractionBox["1", 
           RowBox[{"Rct", "+", 
            FractionBox[
             RowBox[{"R", " ", "T"}], 
             RowBox[{"Co", " ", 
              SqrtBox["Dox"], " ", 
              SuperscriptBox["F", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 FractionBox[
                  SqrtBox["Dox"], "r0"]}], "+", 
                RowBox[{
                 SqrtBox[
                  RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]], " ", 
                 RowBox[{"Coth", "[", 
                  RowBox[{"r0", " ", 
                   SqrtBox[
                    FractionBox[
                    RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
                  "]"}]}]}], ")"}]}]]}]]}]]}], "]"}], "2"]}]], "]"}], 
  RowBox[{"Log", "[", "10", "]"}]]], "Output",
 CellChangeTimes->{
  3.570554493429412*^9, 3.5705548131526985`*^9, 3.5705551274066734`*^9, 
   3.570555320663727*^9, 3.5705555654227266`*^9, 3.570557198701144*^9, 
   3.5705572357882657`*^9, 3.570557271410303*^9, 3.5705579548883963`*^9, {
   3.5705580940633564`*^9, 3.570558133102589*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Omega]", "=", 
  RowBox[{"10", "^", "lom"}]}]], "Input",
 CellChangeTimes->{{3.5705545122914906`*^9, 3.5705545204389567`*^9}}],

Cell[BoxData[
 SuperscriptBox["10", "lom"]], "Output",
 CellChangeTimes->{
  3.570554521526019*^9, 3.570555127457676*^9, 3.5705553207367315`*^9, 
   3.570555565496731*^9, 3.570557198785149*^9, 3.570557235825268*^9, 
   3.5705572714463053`*^9, 3.570557954939399*^9, {3.5705580941353607`*^9, 
   3.570558133168593*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Rs", "=", "10"}], "\[IndentingNewLine]", 
 RowBox[{"Rct", "=", "50"}], "\[IndentingNewLine]", 
 RowBox[{"Cdl", "=", 
  RowBox[{"20", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Dox", "=", 
  RowBox[{"1", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "5"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Co", "=", 
  RowBox[{"2", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"r0", "=", "0.001"}], "\[IndentingNewLine]", 
 RowBox[{"F", "=", "96485"}], "\[IndentingNewLine]", 
 RowBox[{"T", "=", "298.15"}], "\[IndentingNewLine]", 
 RowBox[{"R", "=", "8.31447"}]}], "Input",
 CellChangeTimes->{{3.5218874289926944`*^9, 3.521887476006384*^9}, {
  3.5218880815430183`*^9, 3.5218880856382523`*^9}, {3.5705331185628395`*^9, 
  3.570533164322457*^9}, {3.5705389117301893`*^9, 3.570538957625815*^9}, {
  3.5705545315715933`*^9, 3.5705545321316257`*^9}, {3.5705546440840287`*^9, 
  3.570554744162753*^9}, {3.570555291317048*^9, 3.5705552918600793`*^9}, {
  3.570558088948064*^9, 3.57055814814845*^9}}],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}}],

Cell[BoxData["50"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.5705581332355967`*^9}}],

Cell[BoxData[
 FractionBox["1", "50000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133238597*^9}}],

Cell[BoxData[
 FractionBox["1", "100000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133256598*^9}}],

Cell[BoxData[
 FractionBox["1", "500000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.5705581332595983`*^9}}],

Cell[BoxData["0.001`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.5705581332645984`*^9}}],

Cell[BoxData["96485"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.5705581332685986`*^9}}],

Cell[BoxData["298.15`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133271599*^9}}],

Cell[BoxData["8.31447`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.5705581332785993`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Z1", ",", "Z2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "0.7"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4756034305039873`*^9, 3.4756034317770596`*^9}, {
   3.4756034944846463`*^9, 3.475603513969761*^9}, {3.475603551473906*^9, 
   3.475603587393961*^9}, 3.4756036488824778`*^9, {3.4756036989943438`*^9, 
   3.4756037027855606`*^9}, {3.4756039087223396`*^9, 
   3.4756039240022135`*^9}, {3.475603989492959*^9, 3.475604001249632*^9}, {
   3.475604151650234*^9, 3.4756041615057983`*^9}, {3.475604357794025*^9, 
   3.47560439371408*^9}, {3.475605209794757*^9, 3.4756052162581263`*^9}, {
   3.4756054334265475`*^9, 3.475605473281827*^9}, {3.475605514436181*^9, 
   3.4756055396506233`*^9}, 3.475865811559016*^9, 3.4758664622142315`*^9, 
   3.4899210018204603`*^9, {3.489921220908992*^9, 3.48992123574084*^9}, {
   3.5214770962080016`*^9, 3.521477119023307*^9}, {3.521888419623355*^9, 
   3.5218884200383787`*^9}, {3.521889136119336*^9, 3.521889146198913*^9}, 
   3.521905292455426*^9, 3.521911388120078*^9, {3.5705338870747957`*^9, 
   3.570533898082425*^9}, {3.5705339800831156`*^9, 3.570534005494569*^9}, 
   3.570539142100366*^9, {3.570554838147128*^9, 3.5705548545010643`*^9}, 
   3.5705548849028025`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd13c8lV8YAHAqsgmJjIpr7+2ax8y8IUWyycqeGQkhISN7VYpUElHa7iMV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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0., 61.83143494963486}, {-499.099692257228, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5705572359982777`*^9, 3.570557271602314*^9, 3.5705579551504107`*^9, {
   3.5705580943653736`*^9, 3.5705581333856053`*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5705572046414843`*^9, 3.5705572046984873`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "Zf", "]"}], ",", 
     RowBox[{"Im", "[", "Zf", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.570554936758769*^9, 3.57055496859659*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8Vf8bAHCEbPdmk7JXhGvkEo7tXiMiiWRURgohMopKRWQlNPimkqwG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     "]]}},
  Axes->True,
  AxesOrigin->{50.5, 0},
  Method->{},
  PlotRange->{{50.09413708331218, 52.659495410180085`}, {-20.645663624128055`,
    0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.570557236051281*^9, 3.570557271666318*^9, 3.570557955226415*^9, {
   3.5705580944143763`*^9, 3.5705581334366083`*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.570557207026621*^9, 3.5705572070806236`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CurlyPhi]", "=", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"Z2", "/", "Z1"}], "]"}], "*", 
   RowBox[{"180", "/", "\[Pi]"}]}]}]], "Input",
 CellChangeTimes->{{3.5219007065651283`*^9, 3.5219007065841293`*^9}, {
  3.5705340884983163`*^9, 3.5705341365780663`*^9}, {3.5705342253151417`*^9, 
  3.570534229010353*^9}, {3.570535226003378*^9, 3.5705352276364717`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"180", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"Im", "[", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "4"}], "+", "lom"}]], " ", 
         SuperscriptBox["5", 
          RowBox[{
           RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
        FractionBox["1", 
         RowBox[{"50", "+", 
          FractionBox["42.10365382785329`", 
           RowBox[{
            RowBox[{"-", "3.1622776601683795`"}], "+", 
            RowBox[{
             SqrtBox[
              RowBox[{"\[ImaginaryI]", " ", 
               SuperscriptBox["10", "lom"]}]], " ", 
             RowBox[{"Coth", "[", 
              RowBox[{"0.001`", " ", 
               SqrtBox[
                RowBox[{"\[ImaginaryI]", " ", 
                 SuperscriptBox["10", 
                  RowBox[{"5", "+", "lom"}]]}]]}], "]"}]}]}]]}]]}]], "]"}], 
     RowBox[{"10", "+", 
      RowBox[{"Re", "[", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["2", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "lom"}]], " ", 
          SuperscriptBox["5", 
           RowBox[{
            RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
         FractionBox["1", 
          RowBox[{"50", "+", 
           FractionBox["42.10365382785329`", 
            RowBox[{
             RowBox[{"-", "3.1622776601683795`"}], "+", 
             RowBox[{
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SuperscriptBox["10", "lom"]}]], " ", 
              RowBox[{"Coth", "[", 
               RowBox[{"0.001`", " ", 
                SqrtBox[
                 RowBox[{"\[ImaginaryI]", " ", 
                  SuperscriptBox["10", 
                   RowBox[{"5", "+", "lom"}]]}]]}], "]"}]}]}]]}]]}]], 
       "]"}]}]], "]"}]}], "\[Pi]"]], "Output",
 CellChangeTimes->{
  3.5705341416623573`*^9, 3.5705342311404753`*^9, 3.570535231352684*^9, 
   3.570539161852496*^9, 3.570539343825904*^9, 3.57055489307027*^9, 
   3.570555127712691*^9, 3.5705553209927454`*^9, 3.5705555658767524`*^9, 
   3.570557199095167*^9, 3.5705572360782824`*^9, 3.5705572716983194`*^9, 
   3.570557955257417*^9, {3.570558094444378*^9, 3.57055813346661*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "\[CurlyPhi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "2"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758610857867174`*^9, 3.4758610994945016`*^9}, {
   3.47586139511141*^9, 3.4758614066940727`*^9}, 3.475861522949722*^9, {
   3.475861586262343*^9, 3.475861623062448*^9}, 3.4758639548218164`*^9, {
   3.475864446741953*^9, 3.4758644503101573`*^9}, {3.4758646109663463`*^9, 
   3.4758646390459523`*^9}, {3.4758646771931343`*^9, 3.4758646914299483`*^9}, 
   3.4758665906145754`*^9, 3.4759254965058002`*^9, 3.4899212624123654`*^9, {
   3.4899227056129117`*^9, 3.4899227097861505`*^9}, 3.5214822947193394`*^9, {
   3.521888447014922*^9, 3.521888491815484*^9}, 3.521911393096363*^9, {
   3.5705341597473917`*^9, 3.5705341793945155`*^9}, 3.570555008228857*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nc4lW/4AHAzHGQ7CsUxMrMyKnkf60TZnBMp0aYh0jLKStqFJCMqs0HJ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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{-2., 6.}, {-89.91059821077721, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.570557236110284*^9, 3.570557271809326*^9, 3.5705579553724236`*^9, {
   3.570558094558385*^9, 3.570558133580617*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lom", ",", "Z1", ",", "Z2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"lom", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.48224695415106*^9, 3.4822470058780184`*^9}, 
   3.482247616006916*^9, 3.482249406678336*^9, {3.4899180741550074`*^9, 
   3.489918075995113*^9}, 3.4899212882048407`*^9, {3.4899214747325096`*^9, 
   3.4899214784287205`*^9}, {3.4899218207332993`*^9, 3.489921838733329*^9}, {
   3.4899218689890594`*^9, 3.4899218743173647`*^9}, {3.5214771395024776`*^9, 
   3.521477155727406*^9}, {3.5218885571592216`*^9, 3.5218885778004026`*^9}, {
   3.521888616026589*^9, 3.5218886178476934`*^9}, 3.52188931853577*^9, 
   3.521889982983774*^9, 3.5219051233047514`*^9, {3.5219114029689274`*^9, 
   3.521911407609193*^9}, 3.521911476249119*^9, {3.570535356419838*^9, 
   3.570535388915696*^9}, 3.5705394635877542`*^9, {3.57053949726768*^9, 
   3.57053949778371*^9}, {3.570539586787801*^9, 3.570539603699768*^9}, 
   3.5705397446258287`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<spherint-Mat.txt\>\"", ",", "res", ",", "\"\<Table\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.4822493502621098`*^9, 3.482249404502212*^9, {3.5214771654379616`*^9, 
   3.521477166414017*^9}, {3.5214772797595005`*^9, 3.521477280894565*^9}, {
   3.570535395572077*^9, 3.5705353973291774`*^9}, {3.570539502739993*^9, 
   3.570539506052183*^9}, 3.57053956107633*^9, {3.570539655171712*^9, 
   3.570539663507189*^9}, 3.5705397519122453`*^9, {3.570555063732031*^9, 
   3.5705550730595646`*^9}}],

Cell[BoxData["\<\"spherint-Mat.txt\"\>"], "Output",
 CellChangeTimes->{
  3.4822470588200464`*^9, 3.4822494180059843`*^9, 3.4899206141082845`*^9, 
   3.489921297854392*^9, 3.489921507021356*^9, 3.4899219563290553`*^9, 
   3.4899231604799285`*^9, 3.4899232116098533`*^9, {3.489923243844697*^9, 
   3.4899234299013386`*^9}, 3.489923576874745*^9, 3.489924137500811*^9, 
   3.4899242266079073`*^9, {3.489924259050763*^9, 3.4899242800389633`*^9}, 
   3.48992440848431*^9, 3.489924456798074*^9, 3.4899245311753283`*^9, 
   3.489924572106669*^9, 3.4899246228165693`*^9, 3.521477172796382*^9, 
   3.521477284913795*^9, 3.5214822422093363`*^9, 3.521888435924288*^9, {
   3.521888586032873*^9, 3.521888593822319*^9}, 3.5218886267072*^9, 
   3.5218891977378607`*^9, 3.5218893274762816`*^9, 3.521889636575961*^9, 
   3.521889993244361*^9, 3.52189013240032*^9, 3.52189053118713*^9, 
   3.521890635130075*^9, 3.521890901785327*^9, 3.521892393817666*^9, 
   3.5218924793715596`*^9, 3.521892631782277*^9, 3.5218932292434497`*^9, 
   3.521902174817107*^9, 3.521904361425174*^9, {3.521905116755377*^9, 
   3.521905129597111*^9}, 3.5219114182288003`*^9, 3.5705354057616596`*^9, 
   3.570539344568947*^9, 3.570539511388488*^9, 3.570539566442637*^9, 
   3.57053967402779*^9, 3.570539755160431*^9, 3.570539785664176*^9, 
   3.5705550796219397`*^9, 3.5705551278827004`*^9, 3.5705553211777563`*^9, 
   3.5705555661347675`*^9, 3.5705571992251744`*^9, 3.5705572361762877`*^9, 
   3.5705572718723297`*^9, 3.5705579554434276`*^9, {3.570558094625388*^9, 
   3.5705581336466208`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1902, 918},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{600, 780}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.6000001430511475`,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 645, 13, 186, "Title"],
Cell[CellGroupData[{
Cell[1237, 39, 589, 10, 164, "Input"],
Cell[1829, 51, 1940, 28, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3806, 84, 1844, 29, 54, "Input"],
Cell[5653, 115, 492, 11, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6182, 131, 696, 19, 47, "Input"],
Cell[6881, 152, 937, 26, 87, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7855, 183, 146, 3, 47, "Input"],
Cell[8004, 188, 859, 25, 87, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8900, 218, 308, 9, 47, "Input"],
Cell[9211, 229, 1092, 30, 124, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10340, 264, 147, 3, 47, "Input"],
Cell[10490, 269, 1142, 31, 124, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11669, 305, 147, 3, 47, "Input"],
Cell[11819, 310, 1147, 31, 124, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13003, 346, 365, 9, 77, "Input"],
Cell[13371, 357, 2209, 61, 136, "Output"],
Cell[15583, 420, 2398, 64, 155, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18018, 489, 152, 3, 47, "Input"],
Cell[18173, 494, 317, 6, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18527, 505, 1106, 24, 280, "Input"],
Cell[19636, 531, 390, 5, 47, "Output"],
Cell[20029, 538, 392, 5, 47, "Output"],
Cell[20424, 545, 413, 6, 66, "Output"],
Cell[20840, 553, 414, 6, 66, "Output"],
Cell[21257, 561, 416, 6, 66, "Output"],
Cell[21676, 569, 396, 5, 47, "Output"],
Cell[22075, 576, 395, 5, 47, "Output"],
Cell[22473, 583, 395, 5, 47, "Output"],
Cell[22871, 590, 398, 5, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23306, 600, 1347, 23, 47, "Input"],
Cell[24656, 625, 18054, 303, 715, "Output"]
}, Open  ]],
Cell[42725, 931, 96, 1, 47, InheritFromParent],
Cell[CellGroupData[{
Cell[42846, 936, 331, 9, 47, "Input"],
Cell[43180, 947, 6219, 110, 715, "Output"]
}, Open  ]],
Cell[49414, 1060, 94, 1, 47, InheritFromParent],
Cell[CellGroupData[{
Cell[49533, 1065, 395, 8, 47, "Input"],
Cell[49931, 1075, 2335, 62, 194, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52303, 1142, 908, 16, 47, "Input"],
Cell[53214, 1160, 14729, 249, 715, "Output"]
}, Open  ]],
Cell[67958, 1412, 1139, 22, 47, "Input"],
Cell[CellGroupData[{
Cell[69122, 1438, 550, 10, 47, "Input"],
Cell[69675, 1450, 1554, 22, 47, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
